<?php
// Include the database connection file
require_once 'connection.php';

// Fetch all users from the database
$sql = "SELECT * FROM user";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $users = array();
    while ($row = $result->fetch_assoc()) {
        // Prepare each user's data
        $user = array(
            "id" => $row['id'],
            "name" => $row['name'],
            "email" => $row['email'],
            "image" => $row['image'],
            "fcm" => $row['fcm']
            // Add more fields as needed
        );
        // Add each user to the users array
        $users[] = $user;
    }
    // Success response with all users
    $response = array(
        "status" => "success",
        "users" => $users
    );
} else {
    // No users found
    $response = array(
        "status" => "error",
        "message" => "No users found in the database"
    );
}

header('Content-Type: application/json');
echo json_encode($response);

$conn->close();
?>
