<?php
require_once 'connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the POST data
    $userEmail = $_POST['userEmail'];

    // Prepare the SQL query to join tables
    $query = "
        SELECT 
            gm.groupMemberId, 
            gm.groupId, 
            gm.userEmail, 
            gt.groupName, 
            gt.groupOwnerEmail, 
            gt.groupProfile
        FROM 
            groupmembertable gm
        INNER JOIN 
            grouptable gt ON gm.groupId = gt.groupId
        WHERE 
            gm.userEmail = ?
    ";

    // Prepare the statement
    $stmt = $conn->prepare($query);

    // Bind the parameter
    $stmt->bind_param("s", $userEmail);

    // Execute the statement
    if ($stmt->execute()) {
        // Get the result
        $result = $stmt->get_result();
        
        // Fetch all rows as associative array
        $data = $result->fetch_all(MYSQLI_ASSOC);

        // Return JSON response
        echo json_encode($data);
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close the statement
    $stmt->close();
}

// Close the connection
$conn->close();
?>
