<?php
// Include the database connection file
require_once 'connection.php';

// Check if the request method is POST and required fields are set
if ($_SERVER['REQUEST_METHOD'] === 'POST' &&
    isset($_FILES['image']) &&
    isset($_POST['name']) &&
    isset($_POST['email']) &&
    isset($_POST['fcm'])) {

    // Sanitize inputs
    $name = $_POST['name'];
    $email = $_POST['email'];
    $fcm = $_POST['fcm'];

    // File details
    $image = $_FILES['image'];

    // Check if file upload was successful
    if ($image['error'] === UPLOAD_ERR_OK) {
        $image_filename = uniqid() . '_' . basename($image['name']);
        $image_path = 'profile_images/' . $image_filename;

        // Move uploaded file to destination
        if (move_uploaded_file($image['tmp_name'], $image_path)) {
            // File successfully saved, now prepare for database update
            $image_url = 'http://192.168.1.22/push_talk/' . $image_path; // Update with your actual domain
            // Assuming $conn is your database connection object from 'connection.php'
            // Escape inputs to prevent SQL injection
            $name = $conn->real_escape_string($name);
            $email = $conn->real_escape_string($email);
            $fcm = $conn->real_escape_string($fcm);
            $image_path = $conn->real_escape_string($image_url); // Save image path as string in database

            // Check if the user exists in the database based on email
            $check_sql = "SELECT * FROM user WHERE email = '$email'";
            $check_result = $conn->query($check_sql);

            if ($check_result->num_rows > 0) {
                // User exists, update their image path
$update_sql = "UPDATE user SET image = '$image_url', name = '$name' WHERE email = '$email'";

                if ($conn->query($update_sql) === TRUE) {
                    // Update successful
                    $response = array(
                        "status" => "success",
                        "message" => "Image updated successfully",
                        "image_path" => "http://192.168.1.19/push_talk/" . $image_path
                    );
                } else {
                    // Update failed
                    $response = array(
                        "status" => "error",
                        "message" => "Failed to update image: " . $conn->error
                    );
                }
            } else {
                // User does not exist
                $response = array(
                    "status" => "error",
                    "message" => "User with email '$email' does not exist"
                );
            }
        } else {
            // Failed to move uploaded file
            $response = array(
                "status" => "error",
                "message" => "Failed to save image to server"
            );
        }
    } else {
        // Error in file upload
        $response = array(
            "status" => "error",
            "message" => "Failed to upload image"
        );
    }
} else {
    // No file uploaded or missing required fields
    $response = array(
        "status" => "error",
        "message" => "Missing required fields or no image file received"
    );
}

// Send JSON response
header('Content-Type: application/json');
echo json_encode($response);

// Close database connection
$conn->close();
?>
