<?php
// Ensure connection to database
require_once 'connection.php';

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $sender_email = $_POST['sender_email'];
    $receiver_email = $_POST['receiver_email'];
    $message = $_POST['message'];
    $type = $_POST['type'];
   
    
    // Prepare SQL statement to insert data into chat table
    $sql = "INSERT INTO chat (sender_email, receiver_email, message, type) 
            VALUES (?, ?, ?, ?)";
    
    // Use prepared statement to prevent SQL injection
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $sender_email, $receiver_email, $message, $type);

    // Execute the statement
    if ($stmt->execute()) {
        echo "Data inserted successfully.";
    } else {
        echo "Error: " . $sql . "<br>" . $conn->error;
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
}
?>
