<?php
// Include the database connection file
require_once 'connection.php';

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get the userEmail from the query parameter
    $userEmail = $_GET['userEmail'] ?? null;

    // Validate the userEmail
    if (filter_var($userEmail, FILTER_VALIDATE_EMAIL)) {
        // Prepare the SQL statement to fetch the status
        $stmt = $conn->prepare("SELECT status FROM `userstatus` WHERE userEmail = ?");
        $stmt->bind_param("s", $userEmail);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // Fetch the result as an associative array
            $row = $result->fetch_assoc();
            // Respond with the status
            echo json_encode(["status" => $row['status']]);
        } else {
            // Respond with an error message if no record found
            echo json_encode(["error" => "No record found for the given email."]);
        }

        // Close the statement
        $stmt->close();
    } else {
        // Respond with a validation error message
        echo json_encode(["error" => "Invalid email address."]);
    }
} else {
    // Respond with an error if not a GET request
    echo json_encode(["error" => "Invalid request method. Use GET."]);
}

// Close the database connection
$conn->close();
?>
