<?php
require_once 'connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the POST data
    $groupId = $_POST['groupId'];

    // Prepare the SQL query to join tables
    $query = "
        SELECT 
            gm.groupMemberId, 
            gm.groupId, 
            gm.userEmail,
            u.name,
            u.email,
            u.image,
            u.fcm
        FROM 
            groupmembertable gm
        INNER JOIN 
            user u ON gm.userEmail = u.email
        WHERE 
            gm.groupId = ?
    ";

    // Prepare the statement
    $stmt = $conn->prepare($query);

    // Bind the parameter
    $stmt->bind_param("i", $groupId);

    // Execute the statement
    if ($stmt->execute()) {
        // Get the result
        $result = $stmt->get_result();
        
        // Fetch all rows as associative array
        $data = $result->fetch_all(MYSQLI_ASSOC);

        // Return JSON response
        echo json_encode($data);
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close the statement
    $stmt->close();
}

// Close the connection
$conn->close();
?>
